/*
 * Decompiled with CFR 0.152.
 */
package filenet.sim.animationdp.impl2;

import filenet.sim.animationdp.IVWSIMQueueStats;
import filenet.sim.animationdp.IVWSIMStatistics;
import filenet.sim.animationdp.IVWSIMUserStats;
import filenet.sim.animationdp.IVWSIMWorkClassStats;
import filenet.sim.animationdp.impl2.QueueStats;
import filenet.sim.animationdp.impl2.UserStats;
import filenet.sim.animationdp.impl2.WorkClassStats;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Iterator;

public class Statistics
implements IVWSIMStatistics {
    static final long serialVersionUID = 1L;
    private Hashtable wcStats = new Hashtable();
    private Hashtable qStats = new Hashtable();
    private Hashtable uStats = new Hashtable();
    private int nLaunched = 0;
    private int nCompleted = 0;
    private int nActive = 0;
    private int nOverdue = 0;
    private double totalCost = 0.0;
    private double avgCost = 0.0;
    private long minCycle = 0L;
    private long maxCycle = 0L;
    private double avgCycle = 0.0;

    public IVWSIMWorkClassStats[] getWorkClassesStats() {
        return this.wcStats.values().toArray(new IVWSIMWorkClassStats[0]);
    }

    public IVWSIMQueueStats[] getQueuesStats() {
        return this.qStats.values().toArray(new IVWSIMQueueStats[0]);
    }

    public IVWSIMUserStats[] getUsersStats() {
        return this.uStats.values().toArray(new IVWSIMUserStats[0]);
    }

    public int getAllLaunchedWorkflowCount() {
        return this.nLaunched;
    }

    public int getAllCompletedWorkflowCount() {
        return this.nCompleted;
    }

    public int getAllActiveWorkflowCount() {
        return this.nActive;
    }

    public int getAllOverdueWorkflowCount() {
        return this.nOverdue;
    }

    public double getAllTotalCost() {
        return this.totalCost;
    }

    public double getAllAverageCost() {
        return this.avgCost;
    }

    public long getAllMinCycleTimeForCompletedWorkflow() {
        return this.minCycle;
    }

    public long getAllMaxCycleTimeForCompletedWorkflow() {
        return this.maxCycle;
    }

    public double getAllAvgCycleTimeForCompletedWorkflow() {
        return this.avgCycle;
    }

    public void readFromStream(DataInput in) throws IOException {
        String marker = in.readUTF();
        this.nLaunched = in.readInt();
        this.nCompleted = in.readInt();
        this.nActive = in.readInt();
        this.nOverdue = in.readInt();
        this.totalCost = in.readDouble();
        this.avgCost = in.readDouble();
        this.minCycle = in.readLong();
        this.maxCycle = in.readLong();
        this.avgCycle = in.readDouble();
        int c = in.readInt();
        while (c-- > 0) {
            QueueStats q = new QueueStats();
            q.readFromStream(in);
            QueueStats curQ = (QueueStats)this.qStats.get(q.getId());
            if (curQ == null) {
                curQ = q;
            } else {
                curQ.merge(q);
            }
            this.qStats.put(q.getId(), curQ);
        }
        c = in.readInt();
        while (c-- > 0) {
            UserStats u = new UserStats();
            u.readFromStream(in);
            this.uStats.put(u.getName(), u);
        }
        c = in.readInt();
        while (c-- > 0) {
            WorkClassStats wc = new WorkClassStats();
            wc.readFromStream(in);
            WorkClassStats curWc = (WorkClassStats)this.wcStats.get(wc.getId());
            if (curWc == null) {
                curWc = wc;
            } else {
                curWc.merge(wc);
            }
            this.wcStats.put(wc.getId(), curWc);
        }
    }

    public void merge(Statistics that) {
        this.nLaunched = that.nLaunched;
        this.nCompleted = that.nCompleted;
        this.nActive = that.nActive;
        this.nOverdue = that.nOverdue;
        this.totalCost = that.totalCost;
        this.avgCost = that.avgCost;
        this.minCycle = that.minCycle;
        this.maxCycle = that.maxCycle;
        this.avgCycle = that.avgCycle;
        if (this.qStats.size() == 0) {
            this.qStats = that.qStats;
        } else {
            for (QueueStats q : that.qStats.values()) {
                QueueStats curQ = (QueueStats)this.qStats.get(q.getId());
                if (curQ == null) {
                    curQ = q;
                } else {
                    curQ.merge(q);
                }
                this.qStats.put(q.getId(), curQ);
            }
        }
        if (this.uStats.size() == 0) {
            this.uStats = that.uStats;
        } else {
            for (UserStats u : that.uStats.values()) {
                this.uStats.put(u.getName(), u);
            }
        }
        if (this.wcStats.size() == 0) {
            this.wcStats = that.wcStats;
        } else {
            for (WorkClassStats wc : that.wcStats.values()) {
                WorkClassStats curwc = (WorkClassStats)this.wcStats.get(wc.getId());
                if (curwc == null) {
                    curwc = wc;
                } else {
                    curwc.merge(wc);
                }
                this.wcStats.put(wc.getId(), curwc);
            }
        }
    }

    public void toString(StringBuffer buf) {
        buf.append("<STATS nLaunched=\"").append(this.nLaunched);
        buf.append("\" nCompleted=\"").append(this.nCompleted);
        buf.append("\" nActive=\"").append(this.nActive);
        buf.append("\" nOverdue=\"").append(this.nOverdue);
        buf.append("\" totalCost=\"").append(this.totalCost).append("\" avgCost=\"").append(this.avgCost).append("\" avgCycle=\"").append(this.avgCycle).append("\" minCycle=\"").append(this.minCycle).append("\" maxCycle=\"").append(this.maxCycle).append("\">\n<QUEUES>");
        Iterator iter = this.qStats.values().iterator();
        while (iter.hasNext()) {
            ((QueueStats)iter.next()).toString(buf);
        }
        buf.append("\n</QUEUES>\n<USERS>");
        iter = this.uStats.values().iterator();
        while (iter.hasNext()) {
            ((UserStats)iter.next()).toString(buf);
        }
        buf.append("\n</USERS>\n<WCS>");
        iter = this.wcStats.values().iterator();
        while (iter.hasNext()) {
            ((WorkClassStats)iter.next()).toString(buf);
        }
        buf.append("\n</WCS>\n</STATS>");
    }

    protected int getToStringSize() {
        int size = 256;
        Iterator iter = this.wcStats.values().iterator();
        while (iter.hasNext()) {
            size += ((WorkClassStats)iter.next()).getToStringSize();
        }
        iter = this.qStats.values().iterator();
        while (iter.hasNext()) {
            size += ((QueueStats)iter.next()).getToStringSize();
        }
        iter = this.uStats.values().iterator();
        while (iter.hasNext()) {
            size += ((UserStats)iter.next()).getToStringSize();
        }
        return size;
    }

    public String toString() {
        int size = this.getToStringSize();
        StringBuffer buf = new StringBuffer(size);
        this.toString(buf);
        return buf.toString();
    }

    public void writeToStream(DataOutput out) throws IOException {
        out.writeUTF("STATS.1.0");
        out.writeInt(this.nLaunched);
        out.writeInt(this.nCompleted);
        out.writeInt(this.nActive);
        out.writeInt(this.nOverdue);
        out.writeDouble(this.totalCost);
        out.writeDouble(this.avgCost);
        out.writeLong(this.minCycle);
        out.writeLong(this.maxCycle);
        out.writeDouble(this.avgCycle);
        out.writeInt(this.qStats.size());
        for (QueueStats q : this.qStats.values()) {
            q.writeToStream(out);
        }
        out.writeInt(this.uStats.size());
        for (UserStats u : this.uStats.values()) {
            u.writeToStream(out);
        }
        out.writeInt(this.wcStats.size());
        for (WorkClassStats wc : this.wcStats.values()) {
            wc.writeToStream(out);
        }
    }
}

